
schedule("dock", initDock);

var iconWidth = 48;




function initDock()
{
	var dock = document.getElementById("dock");
	var dockWidth = dock.offsetWidth;
	var dockBackground = document.getElementById("dockBackground");
	var icons = dock.getElementsByTagName("img");

	for (var i = 0; i < icons.length; i++)
	{
		icons[i].style.width = iconWidth + "px";
		icons[i].style.height = icons[i].style.width;
	}

	refreshDockDisplay();
	
	dock.style.marginLeft = -parseInt(dock.offsetWidth / 2) + "px";
	dockBackground.style.marginLeft = -parseInt(dock.offsetWidth / 2) + "px";
	dockBackground.style.width = dock.offsetWidth + "px";
	
	attachEventListener(dock, "mousemove", mousemoveDock, false);
	attachEventListener(dock, "mouseout", mouseoutDock, false);
	
	return true;
}

function refreshDockDisplay()
{
	var dock = document.getElementById("dock");
	var dockBackground = document.getElementById("dockBackground");

	dock.style.marginLeft = -parseInt(dock.offsetWidth / 2) + "px";
	dockBackground.style.marginLeft = -parseInt(dock.offsetWidth / 2) + "px";
	dockBackground.style.width = dock.offsetWidth + "px";
	
	return true;
}




function mousemoveDock(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	var dock = document.getElementById("dock");
	
	if (typeof dock.relaxTimer != "undefined")
	{
		clearTimeout(dock.relaxTimer);
	}
	
	var dockBackground = document.getElementById("dockBackground");
	var icons = dock.getElementsByTagName("img");
	
	if (typeof dock.originalWidth == "undefined")
	{
		dock.originalLeft = dock.offsetLeft;
		dock.originalWidth = dock.offsetWidth;
	}
	
	var mouseX = event.clientX - dock.originalLeft;
	var maxIconWidth = 128;
	var iconDisturbance = 3;
	var currentIcon = parseInt(mouseX / iconWidth);

	if (currentIcon > icons.length - 1)
	{
		currentIcon = icons.length - 1;
	}
	
	for (var i = 0; i < icons.length; i++)
	{
		icons[i].style.width = iconWidth + "px";
		icons[i].style.height = icons[i].style.width;
	}
	
	for (var i = currentIcon - 1; i > -1 && i > currentIcon - iconDisturbance; i--)
	{
		icons[i].style.width = (1 - ((mouseX - ((i + 1) * iconWidth)) / (iconDisturbance * iconWidth))) * maxIconWidth + "px";
		
		if (parseInt(icons[i].style.width) < iconWidth)
		{
			icons[i].style.width = iconWidth + "px";
		}
		
		icons[i].style.height = icons[i].style.width;
	}
	
	for (var i = currentIcon + 1; i < icons.length && i < currentIcon + iconDisturbance && i > -1; i++)
	{
		icons[i].style.width = (1 - (((i * iconWidth) - mouseX) / (iconDisturbance * iconWidth))) * maxIconWidth + "px";
		
		if (parseInt(icons[i].style.width) < iconWidth)
		{
			icons[i].style.width = iconWidth + "px";
		}
		
		icons[i].style.height = icons[i].style.width;
	}
	
	if (currentIcon < icons.length && currentIcon > -1)
	{
		icons[currentIcon].style.width = maxIconWidth + "px";
		icons[currentIcon].style.height = maxIconWidth + "px";
	}
	
	refreshDockDisplay();
	
	return true;
}




function mouseoutDock(event)
{
	var dock = document.getElementById("dock");
	
	dock.relaxTimer = setTimeout("relaxDock()", 50);
	
	return true;
}




function relaxDock()
{
	var dock = document.getElementById("dock");
	var dockBackground = document.getElementById("dockBackground");
	var icons = dock.getElementsByTagName("img");
	var sizeIncrement = 8;
	var stop = true;
	
	for (var i = 0; i < icons.length; i++)
	{
		var currIconWidth = parseInt(icons[i].style.width);

		if (currIconWidth >= iconWidth + sizeIncrement)
		{
			stop = false;
			
			icons[i].style.width = currIconWidth - sizeIncrement + "px";
			icons[i].style.height = icons[i].style.width;
		}
	}
	
	refreshDockDisplay();

	if (!stop)
	{
		dock.relaxTimer = setTimeout("relaxDock()", 25);
	}
	
	return true;
}




function mousedownSafariIcon()
{
	this.src = "images/application_icon_safari_selected.png";
	
	return true;
}




function mouseupSafariIcon()
{
	this.src = "images/application_icon_safari.png";
	
	return true;
}




function clickSafariIcon()
{
	var safariApp = document.getElementById("safariApp");
	var safariAppIframe = document.getElementById("safariAppIframe");
	
	safariApp.style.display = "block";
	safariAppIframe.src = "http://www.themaninblue.com/writing/";
	
	return true;
}